<?php

namespace Sendcrux\Controllers;

use GuzzleHttp\Psr7\Request;
use Sendcrux\Models\Connection;
use Sendcrux\Models\Job;
use Sendcrux\Models\Log as SyncLog;
use Sendcrux\Library\WpHelper;
use Sendcrux\Library\LogTable;

class LogController
{
    /**
     * Log listing page
     */
    public function index($id)
    {
        // index content
        $table = new LogTable();
        $notices = $table->process_bulk_action();
        $table->prepare_items();
        $lastUpdate = SyncLog::getLastUpdate();

        return view('@Sendcrux/log/index.twig', [
            'paging' => paginate_links(['total' => SyncLog::count(), 'current' => $_GET['page']]),
            'table' => $table,
            'current_page' => $_GET['page'],
            'lastUpdate' => $lastUpdate,
            'notices' => $notices
        ]);
    }
}
