<?php

namespace Sendcrux\Library;

use Sendcrux\Models\Job as SyncJob;

class JobTable extends \WP_List_Table
{
    public function get_columns()
    {
        $columns = array(
        'cb'        => '<input type="checkbox" />', // If you don't want to display the checkbox in the title you simply set the value to an empty string
        'id'        => 'ID',
        'created_at' => 'Date/Time',
        'operation' => 'Operation',
        'user_id'   => 'User ID',
        'status'   => 'Status',
      );

        return $columns;
    }

    public function prepare_items()
    {
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        $this->_column_headers = array($columns, $hidden, $sortable);

        $per_page = 20;
        $current_page = $this->get_pagenum();

        $this->items = SyncJob::getItems(['per_page' => $per_page, 'current_page' => $current_page]);

        $this->set_pagination_args(array(
        'total_items' => SyncJob::count(),
        'per_page'    => $per_page
      ));
    }

    public function column_default($item, $column_name)
    {
        switch ($column_name) {
            case 'id':
            case 'user_id':
            case 'created_at':
            case 'operation':
            case 'status':
                return $item[ $column_name ];
                break;
            default:
                return print_r($item, true) ; //Show the whole array for troubleshooting purposes
        }
    }

    public function no_items()
    {
        _e('Empty list');
    }

    public function get_sortable_columns()
    {
        return array(
        'created_at' => array('created_at', false),
        'id' => array('id', false),
        'user_id' => array('user_id', false),
        'operation' => array('operation', false),
        'status' => array('status', false),
      );
    }

    public function column_open($item)
    {
        return sprintf('%1$s<br>%2$s/%3$s', '98%', '287', '14,089');
    }

    public function column_user_id($item)
    {
        return sprintf('<strong>%1$s</strong><br>%2$s', $item['user_email'], $item['user_nicename']);
    }

    public function column_status($item)
    {
        $maps = [
            'new' => 'bg-indigo-300',
        ];
        return sprintf('<span class="label %1$s">%2$s</span>', $maps[$item['status']], $item['status']);
    }

    /*
    function column_click($item)
    {
        return sprintf('%1$s<br>%2$s/%3$s', '98%', '287', '14,089');
    }

    function column_unsubscribe($item)
    {
        return sprintf('%1$s<br>%2$s/%3$s', '98%', '287', '14,089');
    }

    function column_name($item) {
        $actions = array(
            'edit' => sprintf('<a href="?page=%s&action=%s&campaign=%s"><span class="dashicons dashicons-welcome-write-blog"></span> Edit</a>', $_REQUEST['page'], 'edit', $item['id']),
            'delete' => sprintf('<a href="?page=%s&action=%s&campaign=%s"><span class="dashicons dashicons-no"></span> Delete</a>', $_REQUEST['page'], 'delete', $item['id']),
            'pause' => sprintf('<a href="?page=%s&action=%s&campaign=%s"><span class="dashicons dashicons-controls-pause"></span> Pause</a>', $_REQUEST['page'], 'pause', $item['id']),
            'restart' => sprintf('<a href="?page=%s&action=%s&campaign=%s"><span class="dashicons dashicons-image-rotate"></span> Restart</a>', $_REQUEST['page'], 'restart', $item['id']),
            'copy' => sprintf('<a href="?page=%s&action=%s&campaign=%s"><span class="dashicons dashicons-welcome-add-page"></span> Copy</a>', $_REQUEST['page'], 'copy', $item['id']),
        );

        return sprintf('<strong>%1$s</strong><br>%2$s, <strong>1,280</strong> subscribers %3$s', $item['name'], 'Regular', $this->row_actions($actions) );
    }
    */

    public function get_bulk_actions()
    {
        $actions = array(
        'delete'    => __('Delete selected'),
        'delete-all'    => __('Delete all')
      );
        return $actions;
    }

    public function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="jobs[]" value="%s" />',
            $item['id']
        );
    }

    protected function get_views()
    {
        $status_links = array(
            //"all"       => __("<strong>All</strong> (1,700)", 'my-plugin-slug'),
            //"published" => __("<a href='#'>Published (3)</a>", 'my-plugin-slug'),
            //"trashed"   => __("<a href='#'>Trashed (0)</a>", 'my-plugin-slug')
        );
        return $status_links;
    }
    
    public function process_bulk_action()
    {
        // security check!
        if (isset($_POST['_wpnonce']) && ! empty($_POST['_wpnonce'])) {
            $nonce  = filter_input(INPUT_POST, '_wpnonce', FILTER_SANITIZE_STRING);
            $action = 'bulk-' . $this->_args['plural'];

            if (!wp_verify_nonce($nonce, $action)) {
                wp_die('Nope! Security check failed!');
            }
        }
        
        $response = [];
        
        try {
            $action = $this->current_action();
            
            if (!array_key_exists('jobs', $_POST) && $action == 'delete') {
                $response[] = ['message' => 'Please select at least one record to delete', 'type' => 'error'];
                return $response;
            }
                
            switch ($action) {
                case 'delete-all':
                    SyncJob::whereNotNull('id')->delete();
                    $response[] = ['message' => 'All records have been deleted', 'type' => 'success'];
                    break;
                
                case 'delete':
                    $logs = $_POST['jobs'];
                    SyncJob::whereIn('id', $logs)->delete();
                    $response[] = ['message' => sprintf('%s record(s) have been deleted', sizeof($logs)), 'type' => 'success'];
                    break;
                
                default:
                    return;
                    break;
            }
        } catch (\Exception $ex) {
            $response[] = ['message' => 'ERROR: ' . $ex->getMessage(), 'type' => 'error'];
        } finally {
            return $response;
        }
    }
}
