<?php

namespace Sendcrux\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;

class Queue extends Eloquent
{
    protected $fillable = [];

    public static function getItems($params = [])
    {
        if (empty($params)) {
            $items = self::offset(0);
        } else {
            $items = self::limit($params['per_page'])->offset($params['per_page'] * ($params['current_page'] - 1));
            if (array_key_exists('orderby', $_GET)) {
                $items = $items->orderBy($_GET['orderby'], $_GET['order']);
            }
        }
        $items = $items->get()->map(function ($r) {
            return $r->toArray();
        })->toArray();

        return $items;
    }
}
